; (*|  9:59 14/11/1990 *)
DATA	SEGMENT	BYTE PUBLIC
DATA	ENDS

CODE	SEGMENT	BYTE PUBLIC

	PUBLIC	CalcOffset
        PUBLIC  FastWrite,FastWriteXY

	ASSUME	CS:CODE, DS:DATA

;******************************************************	CalcOffset

;calculate Offset in video memory.
;On entry, AX has Row, DI has Column
;On exit, CX and ES have VideoSegment, DI has offset.

CalcOffset	PROC NEAR

	DEC	AX			;Row to	0..24 range
;	MOV	CX, WP VirtualWidth	;CX = Rows per column
	MOV	CX, 80
	MUL	CX			;AX = Row * VirtualWidth
	DEC	DI			;Column	to 0..79 range
	ADD	DI,AX			;DI = (Row * VirtualWidth) + Col
	SHL	DI,1			;Account for attribute bytes
;	MOV	CX,VirtualSegment	;CX = VirtualSegment
	MOV	CX, 0B800H
	MOV	ES,CX			;ES:DI points to VideoSegment:Row,Col
	CLD				;Set direction to forward
	RET				;Return

CalcOffset	ENDP

;******************************************************	FastWrite

;procedure FastWrite(VAR S1,S2,S3; Len,Off: INTEGER);
;move char from array (S1) and attribute from (S2) into video memory (S3)
;for Len bytes starting at offset Off into arrays.

Off	EQU	WORD PTR SS:[BP+6]
Len	EQU	WORD PTR SS:[BP+8]
S3	EQU	DWORD PTR SS:[BP+10]
S2	EQU	DWORD PTR SS:[BP+14]
S1	EQU	DWORD PTR SS:[BP+18]

FastWrite     PROC FAR
	PUSH	BP
	MOV	BP,SP
	PUSH	DS			;Save DS

; first process char array

	MOV	CX,Len
	LDS	SI,S1			;get char array
	LES	DI,S3
	ADD	SI,Off
FW_LOOP1:
	LODSB
	STOSB	  			;save char
	INC	DI			;skip attr
	LOOP	FW_LOOP1

; then process attr array

	MOV	CX,Len
	LDS	SI,S2			;get attr array
	LES	DI,S3
	ADD	SI,Off
FW_LOOP2:
	LODSB
	INC	DI			;skip char
	STOSB	  			;save attr
	LOOP	FW_LOOP2
	POP	DS			;Restore DS
	MOV	SP,BP
	POP	BP
	RET	16

FastWrite	ENDP

;******************************************************	FastWriteXY

;procedure FastWriteXY(VAR S1,S2; Col,Row,Len,Off: INTEGER);
;move char from array (S1) and attribute from (S2) into video memory
;for Len bytes starting at offset Off into arrays.

Row	EQU	WORD PTR SS:[BP+10]
Col	EQU	WORD PTR SS:[BP+12]

FastWriteXY	PROC FAR
	PUSH	BP
	MOV	BP,SP
	PUSH	DS			;Save DS

; first process char array

	MOV	AX,Row
	MOV	DI,Col
	CALL	CalcOffset
	PUSH	DI			;save dest for attr loop
	LDS	SI,S1			;get char array
	ADD	SI,Off
	MOV	CX,Len
FWXY_LOOP1:
	LODSB
	STOSB	  			;save char
	INC	DI			;skip attr
	LOOP	FWXY_LOOP1

; then process attr array

	POP	DI			;recall start of dest
	LDS	SI,S2			;get attr array
	ADD	SI,Off
	MOV	CX,Len
FWXY_LOOP2:
	LODSB
	INC	DI			;skip char
	STOSB	  			;save attr
	LOOP	FWXY_LOOP2
	POP	DS			;Restore DS
	MOV	SP,BP
	POP	BP
	RET	16

FastWriteXY	ENDP


CODE	ENDS

	END

